@extends('layouts.app')

@section('content')
<div class="max-w-2xl mx-auto">
    @auth
        <div class="bg-white rounded-lg shadow-md p-6 mb-8 transform hover:scale-101 transition-transform duration-200">
            <form action="{{ route('posts.store') }}" method="POST">
                @csrf
                <textarea
                    name="content"
                    rows="3"
                    class="w-full p-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                    placeholder="What's on your mind?"
                ></textarea>
                <div class="mt-3 text-right">
                    <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600 transition">
                        Post
                    </button>
                </div>
            </form>
        </div>
    @endauth

    <div class="space-y-6">
        @foreach($posts as $post)
            <div class="bg-white rounded-lg shadow-md p-6 transform hover:scale-101 transition-transform duration-200">
                <div class="flex items-center mb-4">
                    <div class="flex-1">
                        <h3 class="font-semibold text-gray-800">{{ $post->user->username }}</h3>
                        <p class="text-sm text-gray-500">{{ $post->created_at->diffForHumans() }}</p>
                    </div>
                    @can('delete', $post)
                        <form action="{{ route('posts.destroy', $post) }}" method="POST">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-500 hover:text-red-600">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                </svg>
                            </button>
                        </form>
                    @endcan
                </div>

                <p class="text-gray-700 mb-4">{{ $post->content }}</p>

                <div class="flex items-center justify-between text-sm text-gray-500">
                    <div class="flex items-center space-x-4">
                        <form action="{{ route('likes.toggle', $post) }}" method="POST">
                            @csrf
                            <button type="submit" class="flex items-center space-x-1 hover:text-blue-500 transition">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                                </svg>
                                <span>{{ $post->likes->count() }}</span>
                            </button>
                        </form>

                        <button class="flex items-center space-x-1 hover:text-blue-500 transition" onclick="document.getElementById('comments-{{ $post->id }}').classList.toggle('hidden')">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z" />
                            </svg>
                            <span>{{ $post->comments->count() }}</span>
                        </button>
                    </div>
                </div>

                <div id="comments-{{ $post->id }}" class="hidden mt-4 space-y-4">
                    @foreach($post->comments as $comment)
                        <div class="flex space-x-3 text-sm">
                            <div class="flex-1 bg-gray-50 rounded-lg p-3">
                                <div class="font-medium text-gray-900">{{ $comment->user->username }}</div>
                                <div class="text-gray-700">{{ $comment->content }}</div>
                            </div>
                        </div>
                    @endforeach

                    @auth
                        <form action="{{ route('comments.store', $post) }}" method="POST" class="mt-4">
                            @csrf
                            <div class="flex space-x-3">
                                <input
                                    type="text"
                                    name="content"
                                    class="flex-1 border border-gray-200 rounded-lg p-2 text-sm focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                    placeholder="Write a comment..."
                                >
                                <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded-lg text-sm hover:bg-blue-600 transition">
                                    Comment
                                </button>
                            </div>
                        </form>
                    @endauth
                </div>
            </div>
        @endforeach

        {{ $posts->links() }}
    </div>
</div>
@endsection